package ru.yandex.direct.core.entity.cashback.model;

import java.util.Arrays;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableList;

import ru.yandex.direct.ytwrapper.model.YtField;
import ru.yandex.direct.ytwrapper.model.YtTableRow;

/**
 * Таблица с начисленными за месяц кешбэками
 */
@ParametersAreNonnullByDefault
public class CashbackRewardTableRow extends YtTableRow {
    private static final YtField<Long> CLIENT_ID = new YtField<>("client_id", Long.class, YtField.SortOrder.ASCENDING);
    private static final YtField<Integer> SERVICE_ID = new YtField<>("service_id", Integer.class);
    private static final YtField<String> CASHBACK_DETAILS = new YtField<>("cashback_details", String.class);
    private static final YtField<String> REWARD = new YtField<>("reward", String.class);

    public CashbackRewardTableRow() {
        this(List.of());
    }

    public CashbackRewardTableRow(List<YtField> fields) {
        super(ImmutableList.<YtField>builder()
                .addAll(Arrays.asList(CLIENT_ID, SERVICE_ID, CASHBACK_DETAILS, REWARD))
                .addAll(fields)
                .build());
    }

    public Long getClientId() {
        return valueOf(CLIENT_ID);
    }

    public Integer getServiceId() {
        return valueOf(SERVICE_ID);
    }

    public String getCashbackDetails() {
        return valueOf(CASHBACK_DETAILS);
    }

    public String getReward() {
        return valueOf(REWARD);
    }
}
