package ru.yandex.direct.core.entity.cashback.model;

import java.time.LocalDate;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.ytwrapper.model.YtCluster;

@ParametersAreNonnullByDefault
public class CashbackRewardsImportParams {
    private YtCluster cluster;
    private LocalDate date;
    private String tablePath;

    public YtCluster getCluster() {
        return cluster;
    }

    public CashbackRewardsImportParams withCluster(YtCluster cluster) {
        this.cluster = cluster;
        return this;
    }

    public LocalDate getDate() {
        return date;
    }

    public CashbackRewardsImportParams withDate(LocalDate date) {
        this.date = date;
        return this;
    }

    public String getTablePath() {
        return tablePath;
    }

    public CashbackRewardsImportParams withTablePath(String tablePath) {
        this.tablePath = tablePath;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CashbackRewardsImportParams that = (CashbackRewardsImportParams) o;
        return cluster == that.cluster && date.equals(that.date) && tablePath.equals(that.tablePath);
    }

    @Override
    public int hashCode() {
        return Objects.hash(cluster, date, tablePath);
    }
}
