package ru.yandex.direct.core.entity.cashback.repository;

import java.util.List;

import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.cashback.model.CashbackCategory;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.read.JooqReaderWithSupplier;
import ru.yandex.direct.jooqmapper.read.JooqReaderWithSupplierBuilder;

import static ru.yandex.direct.dbschema.ppcdict.tables.CashbackCategories.CASHBACK_CATEGORIES;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;

@Repository
public class CashbackCategoriesRepository {
    private final JooqReaderWithSupplier<CashbackCategory> categoryMapper;
    private final DslContextProvider dslContextProvider;

    public CashbackCategoriesRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
        this.categoryMapper = JooqReaderWithSupplierBuilder.builder(CashbackCategory::new)
                .readProperty(CashbackCategory.ID, fromField(CASHBACK_CATEGORIES.CASHBACK_CATEGORY_ID))
                .readProperty(CashbackCategory.NAME_RU, fromField(CASHBACK_CATEGORIES.NAME_RU))
                .readProperty(CashbackCategory.NAME_EN, fromField(CASHBACK_CATEGORIES.NAME_EN))
                .readProperty(CashbackCategory.DESCRIPTION_RU, fromField(CASHBACK_CATEGORIES.DESCRIPTION_RU))
                .readProperty(CashbackCategory.DESCRIPTION_EN, fromField(CASHBACK_CATEGORIES.DESCRIPTION_EN))
                .readProperty(CashbackCategory.BUTTON_TEXT_RU, fromField(CASHBACK_CATEGORIES.BUTTON_TEXT_RU))
                .readProperty(CashbackCategory.BUTTON_TEXT_EN, fromField(CASHBACK_CATEGORIES.BUTTON_TEXT_EN))
                .readProperty(CashbackCategory.BUTTON_LINK, fromField(CASHBACK_CATEGORIES.BUTTON_LINK))
                .build();
    }

    public List<CashbackCategory> get() {
        return dslContextProvider.ppcdict()
                .select(categoryMapper.getFieldsToRead())
                .from(CASHBACK_CATEGORIES)
                .fetch(categoryMapper::fromDb);
    }

    public CashbackCategory get(String nameRu) {
        return dslContextProvider.ppcdict()
                .select(categoryMapper.getFieldsToRead())
                .from(CASHBACK_CATEGORIES)
                .where(CASHBACK_CATEGORIES.NAME_RU.eq(nameRu))
                .fetchOne(categoryMapper::fromDb);
    }

    public CashbackCategory get(Long id) {
        return dslContextProvider.ppcdict()
                .select(categoryMapper.getFieldsToRead())
                .from(CASHBACK_CATEGORIES)
                .where(CASHBACK_CATEGORIES.CASHBACK_CATEGORY_ID.eq(id))
                .fetchOne(categoryMapper::fromDb);
    }
}
