package ru.yandex.direct.core.entity.cashback.repository;

import java.util.List;
import java.util.Map;

import one.util.streamex.StreamEx;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.cashback.model.CashbackCardsProgram;
import ru.yandex.direct.core.entity.cashback.model.CashbackProgram;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.read.JooqReaderWithSupplier;
import ru.yandex.direct.jooqmapper.read.JooqReaderWithSupplierBuilder;

import static ru.yandex.direct.common.jooqmapperex.read.ReaderBuildersEx.fromLongFieldToBoolean;
import static ru.yandex.direct.dbschema.ppcdict.tables.CashbackCategories.CASHBACK_CATEGORIES;
import static ru.yandex.direct.dbschema.ppcdict.tables.CashbackPrograms.CASHBACK_PROGRAMS;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;

@Repository
public class CashbackProgramsRepository {
    private final JooqReaderWithSupplier<CashbackProgram> programMapper;
    private final JooqReaderWithSupplier<CashbackCardsProgram> cardsProgramMapper;
    private final DslContextProvider dslContextProvider;

    public CashbackProgramsRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
        this.programMapper = JooqReaderWithSupplierBuilder.builder(CashbackProgram::new)
                .readProperty(CashbackProgram.ID, fromField(CASHBACK_PROGRAMS.CASHBACK_PROGRAM_ID))
                .readProperty(CashbackProgram.CATEGORY_ID, fromField(CASHBACK_PROGRAMS.CASHBACK_CATEGORY_ID))
                .readProperty(CashbackProgram.PERCENT, fromField(CASHBACK_PROGRAMS.PERCENT))
                .readProperty(CashbackProgram.NAME_RU, fromField(CASHBACK_PROGRAMS.NAME_RU))
                .readProperty(CashbackProgram.NAME_EN, fromField(CASHBACK_PROGRAMS.NAME_EN))
                .readProperty(CashbackProgram.TOOLTIP_INFO_RU, fromField(CASHBACK_PROGRAMS.TOOLTIP_INFO_RU))
                .readProperty(CashbackProgram.TOOLTIP_INFO_EN, fromField(CASHBACK_PROGRAMS.TOOLTIP_INFO_EN))
                .readProperty(CashbackProgram.TOOLTIP_LINK_TEXT_RU, fromField(CASHBACK_PROGRAMS.TOOLTIP_LINK_TEXT_RU))
                .readProperty(CashbackProgram.TOOLTIP_LINK_TEXT_EN, fromField(CASHBACK_PROGRAMS.TOOLTIP_LINK_TEXT_EN))
                .readProperty(CashbackProgram.TOOLTIP_LINK, fromField(CASHBACK_PROGRAMS.TOOLTIP_LINK))
                .readProperty(CashbackProgram.IS_PUBLIC, fromLongFieldToBoolean(CASHBACK_PROGRAMS.IS_GENERAL))
                .readProperty(CashbackProgram.IS_ENABLED, fromLongFieldToBoolean(CASHBACK_PROGRAMS.IS_ENABLED))
                .readProperty(CashbackProgram.IS_TECHNICAL, fromLongFieldToBoolean(CASHBACK_PROGRAMS.IS_TECHNICAL))
                .readProperty(CashbackProgram.IS_NEW, fromLongFieldToBoolean(CASHBACK_PROGRAMS.IS_NEW))
                .readProperty(CashbackProgram.CATEGORY_NAME_RU, fromField(CASHBACK_CATEGORIES.NAME_RU))
                .readProperty(CashbackProgram.CATEGORY_NAME_EN, fromField(CASHBACK_CATEGORIES.NAME_EN))
                .readProperty(CashbackProgram.CATEGORY_DESCRIPTION_RU, fromField(CASHBACK_CATEGORIES.DESCRIPTION_RU))
                .readProperty(CashbackProgram.CATEGORY_DESCRIPTION_EN, fromField(CASHBACK_CATEGORIES.DESCRIPTION_EN))
                .build();

        this.cardsProgramMapper = JooqReaderWithSupplierBuilder.builder(CashbackCardsProgram::new)
                .readProperty(CashbackCardsProgram.ID, fromField(CASHBACK_PROGRAMS.CASHBACK_PROGRAM_ID))
                .readProperty(CashbackCardsProgram.PERCENT, fromField(CASHBACK_PROGRAMS.PERCENT))
                .readProperty(CashbackCardsProgram.IS_NEW, fromLongFieldToBoolean(CASHBACK_PROGRAMS.IS_NEW))
                .readProperty(CashbackCardsProgram.IS_GENERAL, fromLongFieldToBoolean(CASHBACK_PROGRAMS.IS_GENERAL))
                .readProperty(CashbackCardsProgram.IS_TECHNICAL, fromLongFieldToBoolean(CASHBACK_PROGRAMS.IS_TECHNICAL))
                .readProperty(CashbackCardsProgram.NAME_RU, fromField(CASHBACK_PROGRAMS.NAME_RU))
                .readProperty(CashbackCardsProgram.NAME_EN, fromField(CASHBACK_PROGRAMS.NAME_EN))
                .readProperty(CashbackCardsProgram.TOOLTIP_INFO_RU, fromField(CASHBACK_PROGRAMS.TOOLTIP_INFO_RU))
                .readProperty(CashbackCardsProgram.TOOLTIP_INFO_EN, fromField(CASHBACK_PROGRAMS.TOOLTIP_INFO_EN))
                .readProperty(CashbackCardsProgram.TOOLTIP_LINK_TEXT_RU, fromField(
                        CASHBACK_PROGRAMS.TOOLTIP_LINK_TEXT_RU))
                .readProperty(CashbackCardsProgram.TOOLTIP_LINK_TEXT_EN, fromField(
                        CASHBACK_PROGRAMS.TOOLTIP_LINK_TEXT_EN))
                .readProperty(CashbackCardsProgram.TOOLTIP_LINK, fromField(CASHBACK_PROGRAMS.TOOLTIP_LINK))
                .build();
    }

    public List<CashbackProgram> get() {
        return dslContextProvider.ppcdict()
                .select(programMapper.getFieldsToRead())
                .from(CASHBACK_PROGRAMS)
                .leftJoin(CASHBACK_CATEGORIES)
                .on(CASHBACK_PROGRAMS.CASHBACK_CATEGORY_ID.eq(CASHBACK_CATEGORIES.CASHBACK_CATEGORY_ID))
                .fetch(programMapper::fromDb);
    }

    public CashbackProgram get(Long id) {
        return dslContextProvider.ppcdict()
                .select(programMapper.getFieldsToRead())
                .from(CASHBACK_PROGRAMS)
                .leftJoin(CASHBACK_CATEGORIES)
                .on(CASHBACK_PROGRAMS.CASHBACK_CATEGORY_ID.eq(CASHBACK_CATEGORIES.CASHBACK_CATEGORY_ID))
                .where(CASHBACK_PROGRAMS.CASHBACK_PROGRAM_ID.eq(id))
                .fetchOne(programMapper::fromDb);
    }

    public List<CashbackProgram> getByCategory(Long categoryId) {
        return dslContextProvider.ppcdict()
                .select(programMapper.getFieldsToRead())
                .from(CASHBACK_PROGRAMS)
                .leftJoin(CASHBACK_CATEGORIES)
                .on(CASHBACK_PROGRAMS.CASHBACK_CATEGORY_ID.eq(CASHBACK_CATEGORIES.CASHBACK_CATEGORY_ID))
                .where(CASHBACK_PROGRAMS.CASHBACK_CATEGORY_ID.eq(categoryId))
                .fetch(programMapper::fromDb);
    }

    public Map<Long, CashbackProgram> getByIds(List<Long> ids) {
        return StreamEx.of(dslContextProvider.ppcdict()
                .select(programMapper.getFieldsToRead())
                .from(CASHBACK_PROGRAMS)
                .leftJoin(CASHBACK_CATEGORIES)
                .on(CASHBACK_PROGRAMS.CASHBACK_CATEGORY_ID.eq(CASHBACK_CATEGORIES.CASHBACK_CATEGORY_ID))
                .where(CASHBACK_PROGRAMS.CASHBACK_PROGRAM_ID.in(ids))
                .fetch(programMapper::fromDb)).toMap(CashbackProgram::getId, t -> t);
    }

    public Map<Long, CashbackCardsProgram> getCardsProgramsByIds(List<Long> ids) {
        return StreamEx.of(dslContextProvider.ppcdict()
                .select(cardsProgramMapper.getFieldsToRead())
                .from(CASHBACK_PROGRAMS)
                .where(CASHBACK_PROGRAMS.CASHBACK_PROGRAM_ID.in(ids))
                .fetch(cardsProgramMapper::fromDb)).toMap(CashbackCardsProgram::getId, t -> t);
    }
}
