package ru.yandex.direct.core.entity.cashback.service;

import java.util.List;

import javax.annotation.Nullable;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.cashback.model.CashbackCategory;
import ru.yandex.direct.core.entity.cashback.repository.CashbackCategoriesRepository;

@Service
public class CashbackCategoriesService {

    private final CashbackCategoriesRepository repository;

    @Autowired
    public CashbackCategoriesService(CashbackCategoriesRepository repository) {
        this.repository = repository;
    }

    public List<CashbackCategory> getAllCategories() {
        return repository.get();
    }

    @Nullable
    public CashbackCategory getCategoryByName(@Nullable String name) {
        if (name == null) {
            return null;
        }
        return repository.get(name);
    }

    @Nullable
    public CashbackCategory getCategoryById(@Nullable Long id) {
        if (id == null) {
            return null;
        }
        return repository.get(id);
    }
}
