package ru.yandex.direct.core.entity.cashback.service;

import java.util.Comparator;
import java.util.List;

import javax.annotation.Nullable;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.cashback.model.CashbackProgramCategory;
import ru.yandex.direct.core.entity.cashback.model.CashbackProgramCategoryExtended;
import ru.yandex.direct.core.entity.cashback.repository.CashbackProgramsCategoriesRepository;

@Service
public class CashbackProgramsCategoriesService {
    private final CashbackProgramsCategoriesRepository cashbackProgramsCategoriesRepository;

    @Autowired
    public CashbackProgramsCategoriesService(
            CashbackProgramsCategoriesRepository cashbackProgramsCategoriesRepository) {
        this.cashbackProgramsCategoriesRepository = cashbackProgramsCategoriesRepository;
    }
    /*
     * Возвращает все связи категория-программа. Результат сортируется по категории, а в рамках категории по order
     */
    public List<CashbackProgramCategoryExtended> getAllExtended() {
        var data = cashbackProgramsCategoriesRepository.getAllExtended();
        data.sort(Comparator.comparing(CashbackProgramCategoryExtended::getCategoryId)
                .thenComparing(CashbackProgramCategoryExtended::getOrder));
        return data;
    }

    @Nullable
    public CashbackProgramCategory getByIds(Long categoryId, Long programId) {
        return cashbackProgramsCategoriesRepository.getByIds(categoryId, programId);
    }
}
