package ru.yandex.direct.core.entity.changes.model;

import java.time.LocalDateTime;
import java.util.Set;

/**
 * Класс внутреннего представления запроса для ручки
 * <a href="https://yandex.ru/dev/direct/doc/ref-v5/changes/check-docpage/#input">changes.check</a>.
 */
public class CheckIntReq {

    private Set<Long> campaignIds;
    private Set<Long> adGroupIds;
    private Set<Long> adIds;

    private LocalDateTime fromTime;

    private boolean searchCampaignIdsFlag;
    private boolean searchAdGroupIdsFlag;
    private boolean searchAdIdsFlag;
    private boolean searchCampaignStatFlag;

    public CheckIntReq(
            Set<Long> campaignIds,
            Set<Long> adGroupIds,
            Set<Long> adIds,
            LocalDateTime fromTime,
            boolean searchCampaignIdsFlag,
            boolean searchAdGroupIdsFlag,
            boolean searchAdIdsFlag,
            boolean searchCampaignStatFlag
    ) {
        this.campaignIds = campaignIds;
        this.adGroupIds = adGroupIds;
        this.adIds = adIds;
        this.fromTime = fromTime;
        this.searchCampaignIdsFlag = searchCampaignIdsFlag;
        this.searchAdGroupIdsFlag = searchAdGroupIdsFlag;
        this.searchAdIdsFlag = searchAdIdsFlag;
        this.searchCampaignStatFlag = searchCampaignStatFlag;
    }

    public Set<Long> getCampaignIds() {
        return campaignIds;
    }

    public Set<Long> getAdGroupIds() {
        return adGroupIds;
    }

    public Set<Long> getAdIds() {
        return adIds;
    }

    public LocalDateTime getFromTime() {
        return fromTime;
    }

    public boolean isSearchCampaignIdsFlag() {
        return searchCampaignIdsFlag;
    }

    public boolean isSearchAdGroupIdsFlag() {
        return searchAdGroupIdsFlag;
    }

    public boolean isSearchAdIdsFlag() {
        return searchAdIdsFlag;
    }

    public boolean isSearchCampaignStatFlag() {
        return searchCampaignStatFlag;
    }
}
