package ru.yandex.direct.core.entity.changes.model;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Класс внутреннего представления ответа для ручки
 * <a href="https://yandex.ru/dev/direct/doc/ref-v5/changes/check-docpage/#input">changes.check</a>.
 */
public class CheckIntResp {

    public enum ParamBlock {
        ModifiedCampaignIds,
        ModifiedAdGroupIds,
        ModifiedAdIds,

        NotFoundCampaignIds,
        NotFoundAdGroupIds,
        NotFoundAdIds,

        UnprocessedCampaignIds,
        UnprocessedAdGroupIds,
        UnprocessedAdIds
    }

    private Map<ParamBlock, List<Long>> data;
    private Map<Long, LocalDate> campaignIdToBorderDateMap;

    public CheckIntResp() {
        data = new HashMap<>();
    }

    public List<Long> getIds(ParamBlock paramBlock) {
        return data.get(paramBlock);
    }

    public void setIds(ParamBlock paramBlock, Collection<Long> ids) {
        if (ids != null) {
            data.putIfAbsent(paramBlock, new ArrayList<>(ids));
        }
    }

    public Map<Long, LocalDate> getCampaignIdToBorderDateMap() {
        return campaignIdToBorderDateMap;
    }

    public void setCampaignIdToBorderDateMap(Map<Long, LocalDate> campaignIdToBorderDateMap) {
        this.campaignIdToBorderDateMap = campaignIdToBorderDateMap;
    }
}
