package ru.yandex.direct.core.entity.changes.service;

import java.time.LocalDateTime;

import javax.annotation.ParametersAreNonnullByDefault;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.common.db.PpcProperty;
import ru.yandex.direct.common.db.PpcPropertyNames;

@Service
@ParametersAreNonnullByDefault
public class CheckDictionariesService {
    private static final Logger logger = LoggerFactory.getLogger(CheckDictionariesService.class);
    private final PpcPropertiesSupport ppcPropertiesSupport;

    @Autowired
    public CheckDictionariesService(PpcPropertiesSupport ppcPropertiesSupport) {
        this.ppcPropertiesSupport = ppcPropertiesSupport;
    }

    public LocalDateTime getGeoRegionsUpdateTime() {
        PpcProperty<LocalDateTime> datetime = ppcPropertiesSupport.get(PpcPropertyNames.GEO_REGIONS_UPDATE_TIME);
        return datetime.get();
    }

    public LocalDateTime getGeoTimezonesUpdateTime() {
        PpcProperty<LocalDateTime> datetime = ppcPropertiesSupport.get(PpcPropertyNames.GEO_TIMEZONES_UPDATE_TIME);
        return datetime.get();
    }
}
