package ru.yandex.direct.core.entity.client.container;

import java.util.Collection;

import javax.annotation.Nullable;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.multitype.entity.LimitOffset;

/**
 * Контейнер для фильтров, применяемых при отборе клиентов
 */
public class ClientsQueryFilter {

    private Collection<ClientId> clientIds;

    private Collection<Long> connectOrgIds;
    /**
     * ClientId клиента возвращенного на предыдущей итерации последним при постраничном извлечении клиентов.
     */
    private ClientId lastClientId;
    private boolean connectOrgIdRequired = false;
    private LimitOffset limitOffset;

    public static ClientsQueryFilter getByClientIds(Collection<ClientId> clientIds) {
        return new ClientsQueryFilter()
                .withClientIds(clientIds);
    }

    public static ClientsQueryFilter getByConnectOrgIds(Collection<Long> connectOrgIds) {
        return new ClientsQueryFilter()
                .withConnectOrgIds(connectOrgIds);
    }

    public static ClientsQueryFilter getNextConnectOrgClientsPageFilter(@Nullable ClientId lastClientId, int pageSize) {
        return new ClientsQueryFilter()
                .setConnectOrgIdRequired()
                .withLastClientId(lastClientId)
                .withLimitOffset(new LimitOffset(pageSize, 0));
    }

    public static ClientsQueryFilter getLimitedNextClients(@Nullable ClientId lastClientId, int pageSize) {
        return new ClientsQueryFilter()
                .withLastClientId(lastClientId)
                .withLimitOffset(new LimitOffset(pageSize, 0));
    }

    public Collection<ClientId> getClientIds() {
        return clientIds;
    }

    private ClientsQueryFilter withClientIds(Collection<ClientId> clientIds) {
        this.clientIds = clientIds;
        return this;
    }

    public Collection<Long> getConnectOrgIds() {
        return connectOrgIds;
    }

    private ClientsQueryFilter withConnectOrgIds(Collection<Long> connectOrgIds) {
        this.connectOrgIds = connectOrgIds;
        return this;
    }

    public ClientId getLastClientId() {
        return lastClientId;
    }

    private ClientsQueryFilter withLastClientId(ClientId lastClientId) {
        this.lastClientId = lastClientId;
        return this;
    }

    public boolean getConnectOrgIdRequired() {
        return connectOrgIdRequired;
    }

    private ClientsQueryFilter setConnectOrgIdRequired() {
        this.connectOrgIdRequired = true;
        return this;
    }

    /**
     * При установке LimitOffset возвращаемые роли сортируются по ClientId.
     */
    public LimitOffset getLimitOffset() {
        return limitOffset;
    }

    public ClientsQueryFilter withLimitOffset(LimitOffset limitOffset) {
        this.limitOffset = limitOffset;
        return this;
    }

}
