package ru.yandex.direct.core.entity.client.container;

import javax.annotation.Nullable;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.multitype.entity.LimitOffset;

/**
 * Контейнер для фильтров, применяемых при отборе главных менеджеров
 */
public class PrimaryManagersQueryFilter {

    private ClientId lastClientId;
    private LimitOffset limitOffset;

    public static PrimaryManagersQueryFilter allIdmPrimaryManagers() {
        return new PrimaryManagersQueryFilter();
    }

    public static PrimaryManagersQueryFilter getNextIdmManagersPageFilter(
            @Nullable ClientId lastClientId, int pageSize) {
        return new PrimaryManagersQueryFilter()
                .withLastClientId(lastClientId)
                .withLimitOffset(new LimitOffset(pageSize, 0));
    }

    public ClientId getLastClientId() {
        return lastClientId;
    }

    private PrimaryManagersQueryFilter withLastClientId(ClientId lastClientId) {
        this.lastClientId = lastClientId;
        return this;
    }

    /**
     * При установке LimitOffset возвращаемые роли сортируются сначала по ClientId, потом по PrimaryManagerUid.
     */
    public LimitOffset getLimitOffset() {
        return limitOffset;
    }

    public PrimaryManagersQueryFilter withLimitOffset(LimitOffset limitOffset) {
        this.limitOffset = limitOffset;
        return this;
    }

}
