package ru.yandex.direct.core.entity.client.exception;

import ru.yandex.direct.core.ErrorCodes;
import ru.yandex.direct.core.entity.client.service.validation.ClientDefectTranslations;
import ru.yandex.direct.i18n.Translatable;

/**
 * Ошибка при регистрации клиента в балансе
 */
public final class BalanceErrorException extends AddAgencyClientException {
    private BalanceErrorException(int code, Translatable message, Translatable details) {
        super(code, message, details);
    }

    public static BalanceErrorException newInstance() {
        return new BalanceErrorException(
                ErrorCodes.CANT_CREATE_CLIENT,
                ClientDefectTranslations.INSTANCE.cantCreateClient(),
                ClientDefectTranslations.INSTANCE.cantCreateClientDetails());
    }
}
