package ru.yandex.direct.core.entity.client.exception;

import ru.yandex.direct.core.ErrorCodes;
import ru.yandex.direct.core.entity.client.service.validation.ClientDefectTranslations;
import ru.yandex.direct.core.service.integration.passport.RegisterUserStatus;
import ru.yandex.direct.i18n.Translatable;

/**
 * Ошибка при регистрации клиента в паспорте
 */
public final class PassportErrorException extends AddAgencyClientException {
    private PassportErrorException(int code, Translatable message, Translatable details) {
        super(code, message, details);
    }

    public static PassportErrorException newInstance(RegisterUserStatus errorStatus) {
        if (errorStatus == RegisterUserStatus.LOGIN_OCCUPIED) {
            return new PassportErrorException(
                    ErrorCodes.LOGIN_OCCUPED,
                    ClientDefectTranslations.INSTANCE.loginOccupied(), null);
        } else {
            return new PassportErrorException(
                    ErrorCodes.CANT_CREATE_LOGIN,
                    ClientDefectTranslations.INSTANCE.cantCreateLogin(),
                    ClientDefectTranslations.INSTANCE.cantCreateLoginDetails());
        }
    }
}
