package ru.yandex.direct.core.entity.client.mcc

import ru.yandex.direct.dbschema.ppc.tables.records.ClientMccRequestsRecord
import ru.yandex.direct.dbutil.model.ClientId
import java.time.LocalDateTime

data class ClientMccRequest (
    val requestId: Long?,
    val controlClientId: ClientId,
    val managedClientId: ClientId,
    val createTime: LocalDateTime?,
) {
    companion object {
        fun fromRecord(
            rec: ClientMccRequestsRecord
        ) = ClientMccRequest(rec.requestId, ClientId.fromLong(rec.clientIdFrom), ClientId.fromLong(rec.clientIdTo), rec.createTime)
    }
}
