package ru.yandex.direct.core.entity.client.model;

import java.util.Optional;
import java.util.function.Function;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import ru.yandex.direct.currency.CurrencyCode;
import ru.yandex.direct.i18n.Language;
import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

/**
 * Запрос на создание клиента агентства
 */
@ParametersAreNonnullByDefault
public final class AddAgencyClientRequest implements Model {
    public static final ModelProperty<AddAgencyClientRequest, String> LOGIN =
            prop("login", AddAgencyClientRequest::getLogin);
    public static final ModelProperty<AddAgencyClientRequest, String> FIRST_NAME =
            prop("firstName", AddAgencyClientRequest::getFirstName);
    public static final ModelProperty<AddAgencyClientRequest, String> LAST_NAME =
            prop("lastName", AddAgencyClientRequest::getLastName);
    public static final ModelProperty<AddAgencyClientRequest, CurrencyCode> CURRENCY =
            prop("currency", AddAgencyClientRequest::getCurrency);
    public static final ModelProperty<AddAgencyClientRequest, String> NOTIFICATION_EMAIL =
            prop("notificationEmail", AddAgencyClientRequest::getNotificationEmail);
    public static final ModelProperty<AddAgencyClientRequest, Boolean> ALLOW_EDIT_CAMPAIGNS =
            prop("allowEditCampaigns", AddAgencyClientRequest::getAllowEditCampaigns);
    public static final ModelProperty<AddAgencyClientRequest, Boolean> ALLOW_IMPORT_XLS =
            prop("allowImportXls", AddAgencyClientRequest::getAllowImportXls);
    public static final ModelProperty<AddAgencyClientRequest, Boolean> ALLOW_TRANSFER_MONEY =
            prop("allowTransferMoney", AddAgencyClientRequest::getAllowTransferMoney);
    public static final ModelProperty<AddAgencyClientRequest, Optional<Boolean>> SHARED_ACCOUNT_ENABLED =
            prop("sharedAccountEnabled", AddAgencyClientRequest::getSharedAccountEnabled);

    private String login;
    private String firstName;
    private String lastName;
    private CurrencyCode currency;
    private String notificationEmail;
    private Language notificationLang;
    private boolean sendNews;
    private boolean sendAccNews;
    private boolean sendWarn;
    private boolean hideMarketRating;
    private boolean noTextAutocorrection;
    private Boolean allowEditCampaigns;
    private Boolean allowImportXls;
    private Boolean allowTransferMoney;
    @Nullable
    private Boolean sharedAccountEnabled;

    private static <V> ModelProperty<AddAgencyClientRequest, V> prop(
            String name, Function<AddAgencyClientRequest, V> getter) {
        return ModelProperty.createReadOnly(AddAgencyClientRequest.class, name, getter);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }

    @Nonnull
    public String getLogin() {
        return login;
    }

    @Nonnull
    public AddAgencyClientRequest withLogin(String login) {
        this.login = login.trim();
        return this;
    }

    @Nonnull
    public String getFirstName() {
        return firstName;
    }

    @Nonnull
    public AddAgencyClientRequest withFirstName(String firstName) {
        this.firstName = firstName.trim();
        return this;
    }

    @Nonnull
    public String getLastName() {
        return lastName;
    }

    @Nonnull
    public AddAgencyClientRequest withLastName(String lastName) {
        this.lastName = lastName.trim();
        return this;
    }

    @Nonnull
    public CurrencyCode getCurrency() {
        return currency;
    }

    @Nonnull
    public AddAgencyClientRequest withCurrency(CurrencyCode currency) {
        this.currency = currency;
        return this;
    }

    public String getNotificationEmail() {
        return notificationEmail;
    }

    public AddAgencyClientRequest withNotificationEmail(String notificationEmail) {
        this.notificationEmail = notificationEmail;
        return this;
    }

    public Language getNotificationLang() {
        return notificationLang;
    }

    public AddAgencyClientRequest withNotificationLang(Language notificationLang) {
        this.notificationLang = notificationLang;
        return this;
    }

    public boolean isSendNews() {
        return sendNews;
    }

    public AddAgencyClientRequest withSendNews(boolean sendNews) {
        this.sendNews = sendNews;
        return this;
    }

    public boolean isSendAccNews() {
        return sendAccNews;
    }

    public AddAgencyClientRequest withSendAccNews(boolean sendAccNews) {
        this.sendAccNews = sendAccNews;
        return this;
    }

    public boolean isSendWarn() {
        return sendWarn;
    }

    public AddAgencyClientRequest withSendWarn(boolean sendWarn) {
        this.sendWarn = sendWarn;
        return this;
    }

    public boolean isHideMarketRating() {
        return hideMarketRating;
    }

    public AddAgencyClientRequest withHideMarketRating(boolean hideMarketRating) {
        this.hideMarketRating = hideMarketRating;
        return this;
    }

    public boolean isNoTextAutocorrection() {
        return noTextAutocorrection;
    }

    public AddAgencyClientRequest withNoTextAutocorrection(boolean noTextAutocorrection) {
        this.noTextAutocorrection = noTextAutocorrection;
        return this;
    }

    public Boolean getAllowEditCampaigns() {
        return allowEditCampaigns;
    }

    public AddAgencyClientRequest withAllowEditCampaigns(Boolean allowEditCampaigns) {
        this.allowEditCampaigns = allowEditCampaigns;
        return this;
    }

    public Boolean getAllowImportXls() {
        return allowImportXls;
    }

    public AddAgencyClientRequest withAllowImportXls(Boolean allowImportXls) {
        this.allowImportXls = allowImportXls;
        return this;
    }

    public Boolean getAllowTransferMoney() {
        return allowTransferMoney;
    }

    public AddAgencyClientRequest withAllowTransferMoney(Boolean allowTransferMoney) {
        this.allowTransferMoney = allowTransferMoney;
        return this;
    }

    public Optional<Boolean> getSharedAccountEnabled() {
        return Optional.ofNullable(sharedAccountEnabled);
    }

    public void setSharedAccountEnabled(@Nullable Boolean sharedAccountEnabled) {
        this.sharedAccountEnabled = sharedAccountEnabled;
    }

    public AddAgencyClientRequest withSharedAccountEnabled(@Nullable Boolean sharedAccountEnabled) {
        this.sharedAccountEnabled = sharedAccountEnabled;
        return this;
    }
}
