package ru.yandex.direct.core.entity.client.model;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import ru.yandex.direct.dbutil.model.ClientId;

/**
 * Созданный клиент агентства
 */
public final class AddAgencyClientResponse {
    private String login;
    private String email;
    private String password;
    private ClientId clientId;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }

    public String getLogin() {
        return login;
    }

    public AddAgencyClientResponse withLogin(String login) {
        this.login = login;
        return this;
    }

    public String getEmail() {
        return email;
    }

    public AddAgencyClientResponse withEmail(String email) {
        this.email = email;
        return this;
    }

    public String getPassword() {
        return password;
    }

    public AddAgencyClientResponse withPassword(String password) {
        this.password = password;
        return this;
    }

    public ClientId getClientId() {
        return clientId;
    }

    public AddAgencyClientResponse withClientId(ClientId clientId) {
        this.clientId = clientId;
        return this;
    }
}
