package ru.yandex.direct.core.entity.client.model;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import ru.yandex.direct.dbschema.ppc.enums.ClientsApiOptionsApiEnabled;

/**
 * Параметры доступа к API для клиента (См. описание таблицы clients_api_options)
 */
public final class ClientApiOptions {
    private ClientsApiOptionsApiEnabled enabled;
    private Long unitsDaily;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }

    public ClientsApiOptionsApiEnabled getEnabled() {
        return enabled;
    }

    public ClientApiOptions withEnabled(ClientsApiOptionsApiEnabled enabled) {
        this.enabled = enabled;
        return this;
    }

    public Long getUnitsDaily() {
        return unitsDaily;
    }

    public ClientApiOptions withUnitsDaily(Long unitsDaily) {
        this.unitsDaily = unitsDaily;
        return this;
    }
}
