package ru.yandex.direct.core.entity.client.model;

import static ru.yandex.direct.core.entity.client.Constants.DEFAULT_BANNERS_COUNT_LIMIT;
import static ru.yandex.direct.core.entity.client.Constants.DEFAULT_CALLOUTS_COUNT_LIMIT;
import static ru.yandex.direct.core.entity.client.Constants.DEFAULT_CAMPS_COUNT_LIMIT;
import static ru.yandex.direct.core.entity.client.Constants.DEFAULT_CREATIVE_COUNT_LIMIT;
import static ru.yandex.direct.core.entity.client.Constants.DEFAULT_DISABLED_PLACES_COUNT_LIMIT;
import static ru.yandex.direct.core.entity.client.Constants.DEFAULT_FEEDS_COUNT_LIMIT;
import static ru.yandex.direct.core.entity.client.Constants.DEFAULT_FEED_MAX_FILE_SIZE;
import static ru.yandex.direct.core.entity.client.Constants.DEFAULT_KEYWORDS_COUNT_LIMIT;
import static ru.yandex.direct.core.entity.client.Constants.DEFAULT_PROMO_EXTENSION_COUNT_LIMIT;
import static ru.yandex.direct.core.entity.client.Constants.DEFAULT_UNARC_CAMPS_COUNT_LIMIT;
import static ru.yandex.direct.core.entity.client.Constants.DEFAULT_VIDEO_BLACKLIST_SIZE_LIMIT;


public class ClientLimits extends ClientLimitsBase {

    private Long creativesCountLimit;
    private Long calloutsCountLimit;

    public Long getCampsCountLimitOrDefault() {
        return getLimit(getCampsCountLimit(), DEFAULT_CAMPS_COUNT_LIMIT);
    }

    public Long getPromoExtensionCountLimitOrDefault() {
        return getLimit(getPromoExtensionCountLimit(), DEFAULT_PROMO_EXTENSION_COUNT_LIMIT);
    }

    public Long getUnarcCampsCountLimitOrDefault() {
        return getLimit(getUnarcCampsCountLimit(), DEFAULT_UNARC_CAMPS_COUNT_LIMIT);
    }

    public Long getBannersCountLimitOrDefault() {
        return getLimit(getBannersCountLimit(), DEFAULT_BANNERS_COUNT_LIMIT);
    }

    public Long getKeywordsCountLimitOrDefault() {
        return getLimit(getKeywordsCountLimit(), DEFAULT_KEYWORDS_COUNT_LIMIT);
    }

    public Long getFeedsMaxFileSizeOrDefault() {
        return getLimit(getFeedsMaxFileSize(), DEFAULT_FEED_MAX_FILE_SIZE);
    }

    public Long getFeedCountLimitOrDefault() {
        return getLimit(getFeedsCountLimit(), DEFAULT_FEEDS_COUNT_LIMIT);
    }

    public Long getGeneralBlacklistSizeLimitOrDefault() {
        return getLimit(getGeneralBlacklistSizeLimit(), DEFAULT_DISABLED_PLACES_COUNT_LIMIT);
    }

    public Long getCalloutsCountLimit() {
        return calloutsCountLimit;
    }

    public void setCalloutsCountLimit(Long calloutsCountLimit) {
        this.calloutsCountLimit = calloutsCountLimit;
    }

    public ClientLimits withCalloutsCountLimit(Long calloutsCountLimit) {
        setCalloutsCountLimit(calloutsCountLimit);
        return this;
    }

    public Long getCalloutsCountLimitOrDefault() {
        return getLimit(calloutsCountLimit, DEFAULT_CALLOUTS_COUNT_LIMIT);
    }

    public Long getCreativesCountLimit() {
        return creativesCountLimit;
    }

    public void setCreativesCountLimit(Long creativesCountLimit) {
        this.creativesCountLimit = creativesCountLimit;
    }

    public ClientLimits withCreativesCountLimit(Long creativesCountLimit) {
        setCreativesCountLimit(creativesCountLimit);
        return this;
    }

    public Long getCreativesCountLimitOrDefault() {
        return getLimit(creativesCountLimit, DEFAULT_CREATIVE_COUNT_LIMIT);
    }

    public Long getVideoBlacklistSizeLimitOrDefault() {
        return getLimit(getVideoBlacklistSizeLimit(), DEFAULT_VIDEO_BLACKLIST_SIZE_LIMIT);
    }

    private static long getLimit(Long limit, long defaultLimit) {
        return (limit == null || limit == 0) ? defaultLimit : limit;
    }
}
