package ru.yandex.direct.core.entity.client.model;


import javax.annotation.Nonnull;

import static ru.yandex.direct.core.entity.client.Constants.DEFAULT_FORECAST_REPORTS_COUNT_LIMIT;
import static ru.yandex.direct.core.entity.client.Constants.DEFAULT_STAT_REPORTS_COUNT_LIMIT;
import static ru.yandex.direct.core.entity.client.Constants.DEFAULT_WORDSTAT_REPORTS_COUNT_LIMIT;


public class ClientSpecialLimits {
    @Nonnull
    private Long clientId;
    private Long statReportsCountLimit;
    private Long forecastReportsCountLimit;
    private Long wordstatReportsCountLimit;

    public Long getClientId() {
        return clientId;
    }

    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    public ClientSpecialLimits withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public Long getStatReportsCountLimit() {
        return statReportsCountLimit;
    }

    public Long getStatReportsCountLimitOrDefault() {
        return (statReportsCountLimit == null || statReportsCountLimit == 0) ? DEFAULT_STAT_REPORTS_COUNT_LIMIT
                : statReportsCountLimit;
    }

    public void setStatReportsCountLimit(Long statReportsCountLimit) {
        this.statReportsCountLimit = statReportsCountLimit;
    }

    public ClientSpecialLimits withStatReportsCountLimit(Long statReportsCountLimit) {
        this.statReportsCountLimit = statReportsCountLimit;
        return this;
    }

    public Long getForecastReportsCountLimit() {
        return forecastReportsCountLimit;
    }

    public Long getForecastReportsCountLimitOrDefault() {
        return (forecastReportsCountLimit == null || forecastReportsCountLimit == 0)
                ? DEFAULT_FORECAST_REPORTS_COUNT_LIMIT : forecastReportsCountLimit;
    }

    public void setForecastReportsCountLimit(Long forecastReportsCountLimit) {
        this.forecastReportsCountLimit = forecastReportsCountLimit;
    }

    public ClientSpecialLimits withForecastReportsCountLimit(Long forecastReportsCountLimit) {
        this.forecastReportsCountLimit = forecastReportsCountLimit;
        return this;
    }

    public Long getWordstatReportsCountLimit() {
        return wordstatReportsCountLimit;
    }

    public Long getWordstatReportsCountLimitOrDefault() {
        return (wordstatReportsCountLimit == null || wordstatReportsCountLimit == 0)
                ? DEFAULT_WORDSTAT_REPORTS_COUNT_LIMIT : wordstatReportsCountLimit;
    }

    public void setWordstatReportsCountLimit(Long wordstatReportsCountLimit) {
        this.wordstatReportsCountLimit = wordstatReportsCountLimit;
    }

    public ClientSpecialLimits withWordstatReportsCountLimit(Long wordstatReportsCountLimit) {
        this.wordstatReportsCountLimit = wordstatReportsCountLimit;
        return this;
    }
}
