package ru.yandex.direct.core.entity.client.model;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
public class MediascopeClientMeasurerSettings {
    @JsonProperty("access_token")
    private String accessToken;

    @JsonProperty("refresh_token")
    private String refreshToken;

    @JsonProperty("expires_at")
    private Long expiresAt;

    @JsonProperty("tmsec_prefix")
    private String tmsecPrefix;

    @JsonProperty("username")
    private String username;

    public String getAccessToken() {
        return accessToken;
    }

    public MediascopeClientMeasurerSettings withAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public String getRefreshToken() {
        return refreshToken;
    }

    public MediascopeClientMeasurerSettings withRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    public Long getExpiresAt() {
        return expiresAt;
    }

    public MediascopeClientMeasurerSettings withExpiresAt(Long expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    public String getTmsecPrefix() {
        return tmsecPrefix;
    }

    public MediascopeClientMeasurerSettings withTmsecprefix(String tmsecprefix) {
        this.tmsecPrefix = tmsecprefix;
        return this;
    }

    public String getUsername() {
        return username;
    }

    public MediascopeClientMeasurerSettings withUsername(String username) {
        this.username = username;
        return this;
    }
}
