package ru.yandex.direct.core.entity.client.model.office;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.i18n.Translatable;

import static ru.yandex.direct.core.entity.client.model.office.OfficeContactTranslations.INSTANCE;

/**
 * Контактные данные офиса для города
 * Данные взяты из перлового фронта: i-office-contacts.bemtree.js Если правите их здесь, правьте и там.
 */
@ParametersAreNonnullByDefault
public enum CityContact {
    MSK("+7 (495) 739-37-77", null, INSTANCE.moskowCity(), INSTANCE.workingHours()),
    MSK_FOR_EN("+7 (495) 780-65-20", null, INSTANCE.moskowCity(), INSTANCE.workingHoursForEnRegion()),
    SPB("+7 (812) 633-36-00", "2480", INSTANCE.spbCity(), INSTANCE.workingHours()),
    EKB("+7 (343) 385-01-00", "2480", INSTANCE.ekbCity(), INSTANCE.workingHoursInMoscowTime()),
    NSK("+7 (383) 230-43-06", "2480", INSTANCE.nskCity(), INSTANCE.workingHoursInMoscowTime()),
    KAZAN("+7 (843) 524-71-71", "2480", INSTANCE.kazanCity(), INSTANCE.workingHours()),
    ROSTOV("+7 (863) 268-83-00", "2480", INSTANCE.rostovCity(), INSTANCE.workingHours()),
    N_NOVGOROD("+7 (831) 233-06-06", "2480", INSTANCE.nNovgorodCity(), INSTANCE.workingHours()),
    ALMATY("+7 (727) 313-28-05", null, INSTANCE.almaty(), INSTANCE.workingHoursForAlmaty()),
    OTHER(MSK.phone, null, MSK.city, MSK.getDescription());

    private final String phone;
    @Nullable
    private final String phoneExtension;
    private final Translatable city;
    private final Translatable description;

    CityContact(String phone, @Nullable String phoneExtension, Translatable city, Translatable description) {
        this.phone = phone;
        this.phoneExtension = phoneExtension;
        this.city = city;
        this.description = description;
    }

    public String getPhone() {
        return phone;
    }

    @Nullable
    public String getPhoneExtension() {
        return phoneExtension;
    }

    public Translatable getCity() {
        return city;
    }

    public Translatable getDescription() {
        return description;
    }
}
