package ru.yandex.direct.core.entity.client.model.office;

import java.util.Collections;
import java.util.Set;

import ru.yandex.direct.core.entity.client.service.ClientOfficeService;
import ru.yandex.direct.regions.Region;

import static com.google.common.collect.ImmutableSet.of;

/**
 * Sub-сущность для определения офиса {@link ClientOfficeService#getOfficeContactForFooter}
 */
public enum GeoCity {
    ODESSA(Region.ODESA_DISTRICT_REGION_ID),
    KIEV(Region.KYIV_OBLAST_REGION_ID),
    UA(Region.UKRAINE_REGION_ID),
    KZ(Region.KAZAKHSTAN_REGION_ID),
    BY(Region.BY_REGION_ID),
    MOSCOW(Region.MOSCOW_AND_MOSCOW_PROVINCE_REGION_ID),
    SPB(Region.SAINT_PETERSBURG_AND_LENINGRAD_OBLAST_REGION_ID),
    EBURG(Region.SVERDLOVSK_OBLAST_REGION_ID),
    NOVOSIB(Region.NOVOSIBIRSK_OBLAST_REGION_ID),
    N_NOVGOROD(Region.NIZHNY_NOVGOROD_OBLAST_REGION_ID),
    //Центральный округ (минус Белгородская и Воронежская области)
    CENTER(of(Region.CENTRAL_FEDERAL_DISTRICT_REGION_ID),
            of(Region.BELGOROD_OBLAST_REGION_ID, Region.VORONEZH_OBLAST_REGION_ID)),
    NORTH(Region.NORTHWESTERN_FEDERAL_DISTRICT_REGION_ID),
    //Республика Татарстан, Ульяновская и Самарская области (плюс Кировская область, Удмуртия, Марий Эл, Чувашия, Мордовия)
    TATARSTAN(of(Region.REPUBLIC_OF_TATARSTAN_REGION_ID, Region.ULYANOVSK_OBLAST_REGION_ID,
            Region.SAMARA_OBLAST_REGION_ID, Region.KIROV_OBLAST_REGION_ID, Region.UDMURT_REPUBLIC_REGION_ID,
            Region.MARI_EL_REPUBLIC_REGION_ID, Region.CHUVASH_REPUBLIC_REGION_ID,
            Region.REPUBLIC_OF_MORDOVIA_REGION_ID)),
    //Урал (плюс Башкортостан и Пермский край)
    URAL(of(Region.URAL_FEDERAL_DISTRICT_REGION_ID, Region.REPUBLIC_OF_BASHKORTOSTAN_REGION_ID,
            Region.PERM_KRAI_REGION_ID)),
    //Сибирь и Дальний восток
    SIBERIA(of(Region.SIBERIAN_FEDERAL_DISTRICT_REGION_ID, Region.FAR_EASTERN_FEDERAL_DISTRICT_REGION_ID)),
    //Приволжский округ (минус Башкортостан, Пермский край, Ульяновская и Самарская области, Кировская, Удмуртия, Марий Эл, Чувашия, Мордовия)
    VOLGA(of(Region.VOLGA_FEDERAL_DISTRICT_REGION_ID),
            of(Region.REPUBLIC_OF_BASHKORTOSTAN_REGION_ID, Region.PERM_KRAI_REGION_ID,
                    Region.ULYANOVSK_OBLAST_REGION_ID, Region.SAMARA_OBLAST_REGION_ID, Region.KIROV_OBLAST_REGION_ID,
                    Region.UDMURT_REPUBLIC_REGION_ID, Region.MARI_EL_REPUBLIC_REGION_ID,
                    Region.CHUVASH_REPUBLIC_REGION_ID, Region.REPUBLIC_OF_MORDOVIA_REGION_ID)),
    //Южный округ (плюс Белгородская и Воронежская области) и Северный Кавказ (сейчас у нас Юг включает в себя Северный Кавказ: 11069, 11021, 11010, 11013, 11020, 11024, 11012)
    SOUTH(of(Region.SOUTH_FEDERAL_DISTRICT_REGION_ID, Region.BELGOROD_OBLAST_REGION_ID,
            Region.VORONEZH_OBLAST_REGION_ID)),
    RU(Region.RUSSIA_REGION_ID);

    private final Set<Long> regionIds;
    private final Set<Long> minusRegionIds;

    GeoCity(Long regionId) {
        this(Collections.singleton(regionId), Collections.emptySet());
    }

    GeoCity(Set<Long> regionIds) {
        this(regionIds, Collections.emptySet());
    }

    GeoCity(Set<Long> regionIds, Set<Long> minusRegionIds) {
        this.regionIds = regionIds;
        this.minusRegionIds = minusRegionIds;
    }

    public Set<Long> getRegionIds() {
        return regionIds;
    }

    public Set<Long> getMinusRegionIds() {
        return minusRegionIds;
    }

}
