package ru.yandex.direct.core.entity.client.model.office;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Контактные данные офиса
 * Данные взяты из перлового фронта: i-office-contacts.bemtree.js Если правите их здесь, правьте и там.
 */
@ParametersAreNonnullByDefault
public enum OfficeContact {
    EN(CityContact.MSK_FOR_EN, RegionContact.EN, null),
    MSK(CityContact.MSK, RegionContact.RU, null),
    SPB(CityContact.SPB, RegionContact.RU, null),
    EKB(CityContact.EKB, RegionContact.RU, null),
    KAZAN(CityContact.KAZAN, RegionContact.RU, null),
    ROSTOV(CityContact.ROSTOV, RegionContact.RU, null),
    N_NOVGOROD(CityContact.N_NOVGOROD, RegionContact.RU, null),
    NSK(CityContact.NSK, RegionContact.RU, null),
    UKR(CityContact.MSK, null, null),
    KIEV(CityContact.MSK, null, null),
    KAZ(CityContact.ALMATY, RegionContact.MSK, null),
    TR(null, null, null),
    BLR(null, RegionContact.BLR, RegionContact.BLR_ADD),
    OTHER(CityContact.OTHER, RegionContact.OTHER, null);

    @Nullable
    private final CityContact cityContact;

    @Nullable
    private final RegionContact regionContact;

    @Nullable
    private final RegionContact regionContact2;

    OfficeContact(@Nullable CityContact cityContact, @Nullable RegionContact regionContact,
                  @Nullable RegionContact regionContact2) {
        this.cityContact = cityContact;
        this.regionContact = regionContact;
        this.regionContact2 = regionContact2;
    }

    @Nullable
    public CityContact getCityContact() {
        return cityContact;
    }

    @Nullable
    public RegionContact getRegionContact() {
        return regionContact;
    }

    @Nullable
    public RegionContact getRegionContact2() {
        return regionContact2;
    }
}
