package ru.yandex.direct.core.entity.client.model.office;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.MessageFormatStub;
import ru.yandex.direct.i18n.bundle.TranslationBundle;

/**
 * Переводы для контактных данных офиса
 * Данные взяты из перлового фронта: i-office-contacts.bemtree.js Если правите их здесь, правьте и там.
 */
public interface OfficeContactTranslations extends TranslationBundle {

    OfficeContactTranslations INSTANCE = I18NBundle.implement(OfficeContactTranslations.class);

    @MessageFormatStub("звонок из регионов России бесплатный")
    Translatable freeCallFromRussiansRegion();

    @MessageFormatStub("support service, toll-free from Russian regions")
    Translatable freeCallFromRussiansRegionInEnglish();

    @MessageFormatStub("отдел клиентского сервиса, круглосуточно")
    Translatable freeCallFromBelarus();

    @MessageFormatStub("отдел клиентского сервиса, круглосуточно, звонок из Беларуси бесплатный")
    Translatable freeCallFromBelarusAdditional();

    @MessageFormatStub("с 9:00 до 19:00, звонок из стран СНГ бесплатный")
    Translatable freeCallFromCis();

    @MessageFormatStub("круглосуточно")
    Translatable workingHours();

    @MessageFormatStub("круглосуточно")
    Translatable workingHoursInMoscowTime();

    @MessageFormatStub("support service, call on weekdays from 10:00 to 20:00 Moscow time")
    Translatable workingHoursForEnRegion();

    @MessageFormatStub("по будням с 10:00 до 19:00")
    Translatable workingHoursForAlmaty();

    @MessageFormatStub("Москва")
    Translatable moskowCity();

    @MessageFormatStub("Санкт-Петербург")
    Translatable spbCity();

    @MessageFormatStub("Екатеринбург")
    Translatable ekbCity();

    @MessageFormatStub("Новосибирск")
    Translatable nskCity();

    @MessageFormatStub("Казань")
    Translatable kazanCity();

    @MessageFormatStub("Ростов")
    Translatable rostovCity();

    @MessageFormatStub("Нижний Новгород")
    Translatable nNovgorodCity();

    @MessageFormatStub("Алматы")
    Translatable almaty();

}
