package ru.yandex.direct.core.entity.client.model.office;

import java.util.Set;

import com.google.common.collect.ImmutableSet;

/**
 * Константы офисов из {@code b-campaign-state.bemtree.js}
 */
public enum OfficeName {
    MSK("msk", RegionContact.EN.getPhone()),
    SPB("spb", RegionContact.EN.getPhone()),
    EKB("ekb", RegionContact.EN.getPhone()),
    UKR("ukr", "0 800 60-48-61"),
    KAZ("kaz", null),
    NSK("nsk", RegionContact.EN.getPhone()),
    KAZAN("kazan", RegionContact.EN.getPhone()),
    KIEV("kiev", "0 800 60-48-61"),
    ROSTOV("rostov", RegionContact.EN.getPhone()),
    NNOV("nnov", null),
    BOSTON("boston", null),
    CHE("che", null),
    TUR("tur", null),
    BLR("blr", RegionContact.MSK.getPhone()),
    VVO("vvo", RegionContact.EN.getPhone()),
    KRR("krr", RegionContact.EN.getPhone()),
    RTV("rtv", RegionContact.EN.getPhone()),
    KUF("kuf", RegionContact.EN.getPhone()),
    CEK("cek", RegionContact.EN.getPhone()),
    UFA("ufa", RegionContact.EN.getPhone()),
    VOZ("voz", RegionContact.EN.getPhone()),
    PEE("pee", RegionContact.EN.getPhone()),
    TJM("tjm", RegionContact.EN.getPhone()),
    KRA("kra", RegionContact.EN.getPhone());

    public static final Set<OfficeName> NEW_OFFICES = ImmutableSet.<OfficeName>builder()
            .add(OfficeName.VVO, OfficeName.KRR, OfficeName.RTV, OfficeName.KUF, OfficeName.CEK, OfficeName.UFA,
                    OfficeName.VOZ, OfficeName.PEE, OfficeName.TJM, OfficeName.KRA)
            .build();

    private final String name;
    private final String federalPhone;

    OfficeName(String name, String federalPhone) {
        this.name = name;
        this.federalPhone = federalPhone;
    }

    public String getName() {
        return name;
    }

    public String getFederalPhone() {
        return federalPhone;
    }
}
