package ru.yandex.direct.core.entity.client.model.office;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.i18n.Translatable;

/**
 * Контактные данные офиса для региона
 * Данные взяты из перлового фронта: i-office-contacts.bemtree.js Если правите их здесь, правьте и там.
 */
@ParametersAreNonnullByDefault
public enum RegionContact {
    RU("8 800 234-24-80", null, OfficeContactTranslations.INSTANCE.freeCallFromRussiansRegion()),
    BLR("+375 17 336-31-36", null, OfficeContactTranslations.INSTANCE.freeCallFromBelarus()),
    BLR_ADD("8 820 00-73-00-52", null, OfficeContactTranslations.INSTANCE.freeCallFromBelarusAdditional()),
    EN("8 800 250-96-39", "2482", OfficeContactTranslations.INSTANCE.freeCallFromRussiansRegionInEnglish()),
    MSK("+7 (495) 739-37-77", null, OfficeContactTranslations.INSTANCE.freeCallFromRussiansRegion()),
    OTHER(RU.phone, null, RU.description);

    private final String phone;
    @Nullable
    private final String phoneExtension;
    private final Translatable description;

    RegionContact(String phone, @Nullable String phoneExtension, Translatable description) {
        this.phone = phone;
        this.phoneExtension = phoneExtension;
        this.description = description;
    }

    public String getPhone() {
        return phone;
    }

    @Nullable
    public String getPhoneExtension() {
        return phoneExtension;
    }

    public Translatable getDescription() {
        return description;
    }
}
