package ru.yandex.direct.core.entity.client.repository;

import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.common.jooqmapper.OldJooqMapperBuilder;
import ru.yandex.direct.common.jooqmapper.OldJooqMapperWithSupplier;
import ru.yandex.direct.core.entity.client.model.ClientDomainStripped;
import ru.yandex.direct.dbschema.ppc.enums.AgencyClientRelationsBind;
import ru.yandex.direct.dbschema.ppc.enums.AgencyClientRelationsClientArchived;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.common.jooqmapper.FieldMapperFactory.field;
import static ru.yandex.direct.common.jooqmapperex.FieldMapperFactoryEx.timestampField;
import static ru.yandex.direct.dbschema.ppc.Tables.AGENCY_CLIENT_RELATIONS;
import static ru.yandex.direct.dbschema.ppc.tables.ClientDomainsStripped.CLIENT_DOMAINS_STRIPPED;


@Repository
public class ClientDomainsStrippedRepository {
    private final DslContextProvider dslContextProvider;
    public final OldJooqMapperWithSupplier<ClientDomainStripped> mapper;

    @Autowired
    public ClientDomainsStrippedRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
        this.mapper = createMapper();
    }

    private OldJooqMapperWithSupplier<ClientDomainStripped> createMapper() {
        return new OldJooqMapperBuilder<>(ClientDomainStripped::new)
                .map(field(CLIENT_DOMAINS_STRIPPED.RECORD_ID, ClientDomainStripped.RECORD_ID))
                .map(field(CLIENT_DOMAINS_STRIPPED.CLIENT_ID, ClientDomainStripped.CLIENT_ID))
                .map(field(CLIENT_DOMAINS_STRIPPED.DOMAIN_ID, ClientDomainStripped.DOMAIN_ID))
                .map(timestampField(CLIENT_DOMAINS_STRIPPED.LOGTIME, ClientDomainStripped.LOGTIME))
                .build();
    }

    public Set<ClientDomainStripped> getRecent(Integer shard, Long lastSentRecord, LocalDateTime boundaryTime) {

        return new HashSet<>(dslContextProvider.ppc(shard)
                .select(mapper.getFieldsToRead())
                .from(CLIENT_DOMAINS_STRIPPED)
                .join(AGENCY_CLIENT_RELATIONS).on(AGENCY_CLIENT_RELATIONS.CLIENT_CLIENT_ID
                        .eq(CLIENT_DOMAINS_STRIPPED.CLIENT_ID))
                .where(CLIENT_DOMAINS_STRIPPED.RECORD_ID.gt(lastSentRecord))
                .and(CLIENT_DOMAINS_STRIPPED.DOMAIN_ID.ne(0L))
                .and(CLIENT_DOMAINS_STRIPPED.LOGTIME.gt(boundaryTime))
                .and(AGENCY_CLIENT_RELATIONS.BIND.eq(AgencyClientRelationsBind.Yes))
                .and(AGENCY_CLIENT_RELATIONS.CLIENT_ARCHIVED.eq(AgencyClientRelationsClientArchived.No))
                .fetch()
                .map(mapper::fromDb));
    }
}
