package ru.yandex.direct.core.entity.client.repository;


import java.util.Collection;

import javax.annotation.Nonnull;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.common.jooqmapper.OldJooqMapperBuilder;
import ru.yandex.direct.common.jooqmapper.OldJooqMapperWithSupplier;
import ru.yandex.direct.core.entity.client.model.ClientLimits;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.common.jooqmapper.FieldMapperFactory.field;
import static ru.yandex.direct.common.jooqmapperex.FieldMapperFactoryEx.clientIdField;
import static ru.yandex.direct.dbschema.ppc.tables.ClientLimits.CLIENT_LIMITS;

@Repository
public class ClientLimitsRepository {

    private final OldJooqMapperWithSupplier<ClientLimits> clientLimitMapper;

    private final DslContextProvider ppcDslContextProvider;

    @Autowired
    public ClientLimitsRepository(DslContextProvider ppcDslContextProvider) {
        this.ppcDslContextProvider = ppcDslContextProvider;
        this.clientLimitMapper = createClientLimitsMapper();
    }

    @Nonnull
    public Collection<ClientLimits> fetchByClientIds(int shard, Collection<Long> clientIds) {
        return ppcDslContextProvider.ppc(shard)
                .select(this.clientLimitMapper.getFieldsToRead())
                .from(CLIENT_LIMITS)
                .where(CLIENT_LIMITS.CLIENT_ID.in(clientIds))
                .fetch()
                .map(clientLimitMapper::fromDb);
    }


    public OldJooqMapperWithSupplier<ClientLimits> createClientLimitsMapper() {
        return new OldJooqMapperBuilder<>(ClientLimits::new)
                .map(clientIdField(CLIENT_LIMITS.CLIENT_ID, ClientLimits.CLIENT_ID))
                .map(field(CLIENT_LIMITS.CAMP_COUNT_LIMIT, ClientLimits.CAMPS_COUNT_LIMIT).withDatabaseDefault())
                .map(field(CLIENT_LIMITS.UNARC_CAMP_COUNT_LIMIT, ClientLimits.UNARC_CAMPS_COUNT_LIMIT)
                        .withDatabaseDefault())
                .map(field(CLIENT_LIMITS.BANNER_COUNT_LIMIT, ClientLimits.BANNERS_COUNT_LIMIT).withDatabaseDefault())
                .map(field(CLIENT_LIMITS.KEYWORD_COUNT_LIMIT, ClientLimits.KEYWORDS_COUNT_LIMIT).withDatabaseDefault())
                .map(field(CLIENT_LIMITS.FEED_COUNT_LIMIT, ClientLimits.FEEDS_COUNT_LIMIT).withDatabaseDefault())
                .map(field(CLIENT_LIMITS.FEED_MAX_FILE_SIZE, ClientLimits.FEEDS_MAX_FILE_SIZE).withDatabaseDefault())
                .map(field(CLIENT_LIMITS.GENERAL_BLACKLIST_SIZE_LIMIT, ClientLimits.GENERAL_BLACKLIST_SIZE_LIMIT)
                        .withDatabaseDefault())
                .map(field(CLIENT_LIMITS.VIDEO_BLACKLIST_SIZE_LIMIT, ClientLimits.VIDEO_BLACKLIST_SIZE_LIMIT)
                        .withDatabaseDefault())
                .build();
    }
}
