package ru.yandex.direct.core.entity.client.repository;

import java.util.Arrays;
import java.util.List;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.account.score.model.AccountScoreFactors;
import ru.yandex.direct.core.entity.client.model.Client;
import ru.yandex.direct.currency.CurrencyCode;
import ru.yandex.direct.dbschema.ppc.enums.ClientsWorkCurrency;
import ru.yandex.direct.utils.JsonUtils;

import static ru.yandex.direct.utils.CommonUtils.nvl;

public class ClientMapping {
    private ClientMapping() {
    }

    public static ClientsWorkCurrency workCurrencyToDb(CurrencyCode currencyCode) {
        return currencyCode != null ?
                ClientsWorkCurrency.valueOf(currencyCode.name()) : null;
    }

    public static CurrencyCode workCurrencyFromDb(ClientsWorkCurrency workCurrency) {
        return workCurrency != null ?
                CurrencyCode.valueOf(workCurrency.name()) : CurrencyCode.YND_FIXED;
    }

    public static Client postProcess(Client client) {
        return client
                .withHideMarketRating(nvl(client.getHideMarketRating(), false))
                .withNoTextAutocorrection(nvl(client.getNoTextAutocorrection(), false))
                .withNoDisplayHref(nvl(client.getNoDisplayHref(), false))
                .withNotConvertToCurrency(nvl(client.getNotConvertToCurrency(), false))
                .withCanCopyCtr(nvl(client.getCanCopyCtr(), false))
                .withSharedAccountDisabled(nvl(client.getSharedAccountDisabled(), false));
    }

    @Nullable
    public static AccountScoreFactors accountScoreFromDb(@Nullable String factorsJson) {
        return factorsJson != null ? JsonUtils.fromJson(factorsJson, AccountScoreFactors.class) : null;
    }

    @Nullable
    public static String accountScoreToDb(@Nullable AccountScoreFactors accountScoreFactors) {
        return accountScoreFactors != null ? JsonUtils.toJson(accountScoreFactors) : null;
    }

    public static String disallowedPageIdsToDbFormat(List<Long> disallowedPageIds) {
        return disallowedPageIds == null ? null : JsonUtils.toJson(disallowedPageIds);
    }

    public static List<Long> disallowedPageIdsFromDbFormat(String json) {
        if (json == null) {
            return null;
        }
        return Arrays.asList(JsonUtils.fromJson(json, Long[].class));
    }

    public static List<String> defaultAllowedDomainsFromDbFormat(String json) {
        if (json == null) {
            return null;
        }
        return Arrays.asList(JsonUtils.fromJson(json, String[].class));
    }
}
