package ru.yandex.direct.core.entity.client.repository.mapper;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.client.model.ClientMeasurerSettings;
import ru.yandex.direct.core.entity.client.model.ClientMeasurerSystem;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;

import static ru.yandex.direct.dbschema.ppc.Tables.CLIENT_MEASURERS_SETTINGS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;

@ParametersAreNonnullByDefault
public class ClientMeasurerSettingsMapperProvider {

    private static final JooqMapperWithSupplier<ClientMeasurerSettings> MAPPER = createMapper();

    private ClientMeasurerSettingsMapperProvider() {
    }

    public static JooqMapperWithSupplier<ClientMeasurerSettings> getClientMeasurerSettingsMapper() {
        return MAPPER;
    }

    private static JooqMapperWithSupplier<ClientMeasurerSettings> createMapper() {
        return JooqMapperWithSupplierBuilder.builder(ClientMeasurerSettings::new)
                .map(property(ClientMeasurerSettings.CLIENT_ID, CLIENT_MEASURERS_SETTINGS.CLIENT_ID))
                .map(convertibleProperty(ClientMeasurerSettings.CLIENT_MEASURER_SYSTEM,
                        CLIENT_MEASURERS_SETTINGS.MEASURER_SYSTEM,
                        ClientMeasurerSystem::fromSource, ClientMeasurerSystem::toSource))
                .map(property(ClientMeasurerSettings.SETTINGS, CLIENT_MEASURERS_SETTINGS.SETTINGS))
                .readProperty(ClientMeasurerSettings.LAST_CHANGE, fromField(CLIENT_MEASURERS_SETTINGS.LAST_CHANGE))
                .build();
    }
}
