package ru.yandex.direct.core.entity.client.service;

//Параметры создания клиента для AddClientService
public class AddClientOptions {
    //разрешать ли клиенту оплату до модерации
    private boolean paymentBeforeModerationAllowed;
    //использовать ли существующий ClientId в балансе при наличии такового и отсутствии пользователя в директе
    private boolean useExistingIfRequired;
    //создавать ли клиента в API. false=создавать, true=не создавать
    private boolean disableApi;
    //создавать ли общий счёт сразу (а не при создании первой кампании)
    private boolean withWallet;

    public boolean getPaymentBeforeModerationAllowed() {
        return paymentBeforeModerationAllowed;
    }

    public AddClientOptions withPaymentBeforeModerationAllowed(boolean paymentBeforeModerationAllowed) {
        this.paymentBeforeModerationAllowed = paymentBeforeModerationAllowed;
        return this;
    }

    public boolean getUseExistingIfRequired() {
        return useExistingIfRequired;
    }

    public AddClientOptions withUseExistingIfRequired(boolean useExistingIfRequired) {
        this.useExistingIfRequired = useExistingIfRequired;
        return this;
    }

    public boolean getDisableApi() {
        return disableApi;
    }

    public AddClientOptions withDisableApi(boolean disableApi) {
        this.disableApi = disableApi;
        return this;
    }

    public boolean isWithWallet() {
        return withWallet;
    }

    public AddClientOptions withWallet(boolean withWallet) {
        this.withWallet = withWallet;
        return this;
    }

    public static AddClientOptions defaultOptions() {
        return new AddClientOptions()
                .withPaymentBeforeModerationAllowed(false)
                .withUseExistingIfRequired(false)
                .withDisableApi(false)
                .withWallet(false);
    }
}
