package ru.yandex.direct.core.entity.client.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.bs.resync.queue.repository.BsResyncQueueRepository;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.client.model.Client;
import ru.yandex.direct.core.entity.client.repository.ClientRepository;
import ru.yandex.direct.core.entity.client.service.validation.UpdateClientValidationService;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.operation.Applicability;

@Component
public class ClientUpdateOperationProvider {
    private final ClientRepository clientRepository;
    private final ClientService clientService;
    private final CampaignRepository campaignRepository;
    private final BsResyncQueueRepository bsResyncQueueRepository;
    private final UpdateClientValidationService updateClientValidationService;
    private final ShardHelper shardHelper;

    @Autowired
    public ClientUpdateOperationProvider(ClientRepository clientRepository,
                                         ClientService clientService,
                                         CampaignRepository campaignRepository,
                                         BsResyncQueueRepository bsResyncQueueRepository,
                                         UpdateClientValidationService updateClientValidationService,
                                         ShardHelper shardHelper) {
        this.clientRepository = clientRepository;
        this.clientService = clientService;
        this.campaignRepository = campaignRepository;
        this.bsResyncQueueRepository = bsResyncQueueRepository;
        this.updateClientValidationService = updateClientValidationService;
        this.shardHelper = shardHelper;
    }

    public ClientUpdateOperation get(List<ModelChanges<Client>> modelChanges, long operatorUid) {
        return new ClientUpdateOperation(Applicability.PARTIAL, modelChanges, clientRepository, clientService,
                campaignRepository,
                bsResyncQueueRepository, updateClientValidationService, shardHelper, operatorUid);
    }
}
