package ru.yandex.direct.core.entity.client.service.checker;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.addition.callout.model.Callout;
import ru.yandex.direct.core.entity.addition.callout.repository.CalloutRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;

@Component
@ParametersAreNonnullByDefault
class ClientAccessCheckerAdExtensionTypeSupport implements ClientAccessCheckerTypeSupport<Callout> {

    private final ShardHelper shardHelper;
    private final CalloutRepository calloutRepository;

    @Autowired
    ClientAccessCheckerAdExtensionTypeSupport(CalloutRepository calloutRepository, ShardHelper shardHelper) {
        this.calloutRepository = calloutRepository;
        this.shardHelper = shardHelper;
    }

    @Override
    public Set<Long> getAccessibleObjectIds(Collection<Long> objectIds, ClientId clientId) {
        if (objectIds.isEmpty()) {
            return Collections.emptySet();
        }
        return calloutRepository.getExistingCalloutIds(shardHelper.getShardByClientIdStrictly(clientId),
                clientId, objectIds);
    }

    @Override
    public Class<Callout> getObjectClass() {
        return Callout.class;
    }
}
