package ru.yandex.direct.core.entity.client.service.checker;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.creative.model.Creative;
import ru.yandex.direct.core.entity.creative.repository.CreativeRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;

@Component
@ParametersAreNonnullByDefault
class ClientAccessCheckerCreativeTypeSupport implements ClientAccessCheckerTypeSupport<Creative> {

    private final CreativeRepository creativeRepository;
    private final ShardHelper shardHelper;

    @Autowired
    ClientAccessCheckerCreativeTypeSupport(CreativeRepository creativeRepository, ShardHelper shardHelper) {
        this.creativeRepository = creativeRepository;
        this.shardHelper = shardHelper;
    }

    @Override
    public Set<Long> getAccessibleObjectIds(Collection<Long> objectIds, ClientId clientId) {
        if (objectIds.isEmpty()) {
            return Collections.emptySet();
        }
        return creativeRepository.getExistingClientCreativeIds(shardHelper.getShardByClientIdStrictly(clientId),
                clientId, objectIds);
    }

    @Override
    public Class<Creative> getObjectClass() {
        return Creative.class;
    }
}
