package ru.yandex.direct.core.entity.client.service.checker;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;
import ru.yandex.direct.core.entity.retargeting.repository.RetargetingConditionRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;

@Component
@ParametersAreNonnullByDefault
class ClientAccessCheckerRetargetingListTypeSupport implements ClientAccessCheckerTypeSupport<RetargetingCondition> {

    private final RetargetingConditionRepository retargetingConditionRepository;
    private final ShardHelper shardHelper;

    @Autowired
    ClientAccessCheckerRetargetingListTypeSupport(RetargetingConditionRepository retargetingConditionRepository,
                                                  ShardHelper shardHelper) {
        this.retargetingConditionRepository = retargetingConditionRepository;
        this.shardHelper = shardHelper;
    }

    @Override
    public Set<Long> getAccessibleObjectIds(Collection<Long> objectIds, ClientId clientId) {
        if (objectIds.isEmpty()) {
            return Collections.emptySet();
        }
        return retargetingConditionRepository.getExistingRetargetingConditionIdsExceptIgnoredTypes(
                shardHelper.getShardByClientIdStrictly(clientId), clientId, objectIds);
    }

    @Override
    public Class<RetargetingCondition> getObjectClass() {
        return RetargetingCondition.class;
    }
}
