package ru.yandex.direct.core.entity.client.service.checker;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.sitelink.model.SitelinkSet;
import ru.yandex.direct.core.entity.sitelink.repository.SitelinkSetRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;

@Component
@ParametersAreNonnullByDefault
class ClientAccessCheckerSitelinkSetTypeSupport implements ClientAccessCheckerTypeSupport<SitelinkSet> {

    private final SitelinkSetRepository sitelinkSetRepository;
    private final ShardHelper shardHelper;

    @Autowired
    ClientAccessCheckerSitelinkSetTypeSupport(SitelinkSetRepository sitelinkSetRepository, ShardHelper shardHelper) {
        this.sitelinkSetRepository = sitelinkSetRepository;
        this.shardHelper = shardHelper;
    }

    @Override
    public Set<Long> getAccessibleObjectIds(Collection<Long> objectIds, ClientId clientId) {
        if (objectIds.isEmpty()) {
            return Collections.emptySet();
        }
        return sitelinkSetRepository.get(shardHelper.getShardByClientIdStrictly(clientId), clientId, objectIds)
                .stream()
                .map(SitelinkSet::getId)
                .collect(Collectors.toSet());
    }

    @Override
    public Class<SitelinkSet> getObjectClass() {
        return SitelinkSet.class;
    }
}
