package ru.yandex.direct.core.entity.client.service.checker;

import java.util.Collection;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.model.ModelWithId;

/**
 * Интерфейс для реализации типоспецифичной проверки объектов на принадлежность клиенту.
 *
 * @param <ObjectType> тип объекта.
 */
@ParametersAreNonnullByDefault
interface ClientAccessCheckerTypeSupport<ObjectType extends ModelWithId> {

    /**
     * Вернуть все объекты, принадлежащие клиенту
     *
     * @param objectIds id объектов, подлежащих проверке
     * @param clientId   id клиента
     * @return Результат проверки объектов на принадлежность клиенту.
     */
    Set<Long> getAccessibleObjectIds(Collection<Long> objectIds, ClientId clientId);

    /**
     * @return Класс объектов, с которой работает данная реализация.
     */
    Class<ObjectType> getObjectClass();
}
