package ru.yandex.direct.core.entity.client.service.checker;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import one.util.streamex.EntryStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.model.ModelWithId;

@Component
public class ClientAccessCheckerTypeSupportFacade {

    private final Map<Class, ClientAccessCheckerTypeSupport> typeSupportMap;

    @Autowired
    public ClientAccessCheckerTypeSupportFacade(List<ClientAccessCheckerTypeSupport> typeSupportList) {
        this.typeSupportMap = ImmutableMap.copyOf(
                Maps.uniqueIndex(typeSupportList, ClientAccessCheckerTypeSupport::getObjectClass));
    }

    /**
     * Отправление объектов на проверку принадлежности клиенту
     *
     * @param objects  мап, содержащий тип объекта и список id объектов этого типа
     * @param clientId id клиента
     * @return мап, содержащий тип объекта и сет id объектов, прошедших проверку
     */
    public Map<Class<? extends ModelWithId>, Set<Long>> sendToCheck(
            Map<Class<? extends ModelWithId>, Collection<Long>> objects,
            ClientId clientId) {
        if (objects.isEmpty()) {
            return Collections.emptyMap();
        }
        return EntryStream.of(objects)
                .<Set<Long>>mapToValue(
                        (objectType, objectIds) ->
                                typeSupportMap.get(objectType).getAccessibleObjectIds(objectIds, clientId))
                .toMap();
    }
}
