package ru.yandex.direct.core.entity.client.service.validation;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.currency.service.CurrencyService;
import ru.yandex.direct.currency.CurrencyCode;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.validation.wrapper.DefaultValidator;

@Component
@Lazy
@ParametersAreNonnullByDefault
public class AgencyClientCurrencyValidatorFactory {
    private final CurrencyService currencyService;

    @Autowired
    public AgencyClientCurrencyValidatorFactory(CurrencyService currencyService) {
        this.currencyService = currencyService;
    }

    /**
     * Создать валидатор валюты для клиента агентства
     *
     * @param agencyClientId    Идентификатор агентства в балансе
     */
    public DefaultValidator<CurrencyCode> newInstance(ClientId agencyClientId) {
        return new AgencyClientCurrencyValidator(currencyService, agencyClientId);
    }
}
