package ru.yandex.direct.core.entity.client.service.validation;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.MessageFormatStub;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.bundle.TranslationStub;

public interface ClientDefectTranslations extends TranslationBundle {
    ClientDefectTranslations INSTANCE = I18NBundle.implement(ClientDefectTranslations.class);

    @MessageFormatStub("Нет разрешения создавать клиентов")
    Translatable forbiddenCreateSubclientDetails();

    @MessageFormatStub("Список доступных валют не определен. Обратитесь в службу поддержки")
    Translatable noAvailableCurrenciesDetails();

    @MessageFormatStub("Валюта {0} недоступна агентству. Агентство может регистрировать клиентов в {1}")
    Translatable invalidCurrencyDetails(String currency, String validCurrencies);

    @TranslationStub("Не удалось создать учетную запись пользователя на Яндексе")
    Translatable cantCreateLogin();

    @TranslationStub("Повторите попытку позже")
    Translatable cantCreateLoginDetails();

    @TranslationStub("Логин уже используется")
    Translatable loginOccupied();

    @TranslationStub("Не удалось создать клиента")
    Translatable cantCreateClient();

    @TranslationStub("Не удалось создать клиента в Директе с этим логином, используйте другой логин")
    Translatable cantCreateClientDetails();

    @MessageFormatStub("Клиент не должен быть фрилансером")
    Translatable mustNotBeFreelancer();

    @MessageFormatStub("Клиент имеет не соответствующую для данной операции роль")
    Translatable notAppropriateRole();

}
