package ru.yandex.direct.core.entity.client.service.validation;

import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectId;

import static ru.yandex.direct.core.entity.client.service.validation.ClientDefects.Gen.MUST_NOT_BE_FREELANCER;
import static ru.yandex.direct.core.entity.client.service.validation.ClientDefects.Gen.NOT_APPROPRIATE_ROLE;

public class ClientDefects {
    private ClientDefects() {
    }

    public enum Gen implements DefectId<Void> {
        MUST_NOT_BE_FREELANCER,
        NOT_APPROPRIATE_ROLE,
    }


    public static Defect mustNotBeFreelancer() {
        return new Defect<>(MUST_NOT_BE_FREELANCER);
    }

    public static Defect notAppropriateRole() {
        return new Defect<>(NOT_APPROPRIATE_ROLE);
    }

}
