package ru.yandex.direct.core.entity.client.service.validation;

import javax.annotation.Nonnull;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.client.model.Client;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

@Component
public class ClientValidationService {
    /**
     * Валидировать применённые изменения
     * <p>
     * Проверяет не нарушены ли требования к модели клиента после применения измененений
     *
     * @param appliedChanges применённые изменения
     * @return результат валидации клиента
     */
    @Nonnull
    public ValidationResult<Client, Defect> validate(AppliedChanges<Client> appliedChanges) {
        return validateClient(appliedChanges.getModel());
    }

    /**
     * Проверить корректность модели клиента
     *
     * @param client экземпляр клиента, для проверки
     * @return результат проверки
     */
    public ValidationResult<Client, Defect> validateClient(Client client) {
        ModelItemValidationBuilder<Client> vb = ModelItemValidationBuilder.of(client);
        // пока валидация не потребовалась, но метод создан и вызывается при обновлении клиента
        return vb.getResult();
    }
}
