package ru.yandex.direct.core.entity.client.service.validation;

import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.DefaultValidator;

import static ru.yandex.direct.validation.constraint.StringConstraints.maxStringLength;
import static ru.yandex.direct.validation.constraint.StringConstraints.notBlank;
import static ru.yandex.direct.validation.constraint.StringConstraints.validEmail;

/**
 * Валидатор нотификационного email-а для клиента агентства
 */
@Component
public class NotificationEmailValidator implements DefaultValidator<String> {
    static final int MAX_SIZE = 255;

    @Override
    public ValidationResult<String, Defect> apply(String email) {
        return ItemValidationBuilder.<String, Defect>of(email)
                .check(notBlank())
                .check(maxStringLength(MAX_SIZE))
                .check(validEmail(), When.isValid())
                .getResult();
    }
}
