package ru.yandex.direct.core.entity.client.service.validation;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.client.model.Client;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.rbac.RbacService;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.util.ModelChangesValidationTool;

import static java.util.stream.Collectors.toList;

@Service
@ParametersAreNonnullByDefault
public class UpdateClientValidationService {
    private final RbacService rbacService;
    private final ModelChangesValidationTool preValidationTool;

    @Autowired
    public UpdateClientValidationService(RbacService rbacService) {
        this.rbacService = rbacService;
        this.preValidationTool = new ModelChangesValidationTool();
    }

    /**
     * Валидация ModelChanges
     * <p>
     * Проверка дубликатов, корректности id и доступности объекта оператору
     */
    public ValidationResult<List<ModelChanges<Client>>, Defect> preValidate(
            List<ModelChanges<Client>> modelChangesList, long operatorUid) {
        List<ClientId> clientIds = modelChangesList.stream()
                .map(ModelChanges::getId)
                .map(ClientId::fromLong)
                .collect(toList());
        Map<ClientId, Long> clientIdToChiefUid = rbacService.getChiefsByClientIds(clientIds);
        Set<Long> visibleClientsUids = new HashSet<>(
                rbacService.getAccessibleAgencySubclients(operatorUid, clientIdToChiefUid.values()));
        Set<Long> visibleClientIds = clientIdToChiefUid.entrySet().stream()
                .filter(x -> visibleClientsUids.contains(x.getValue()))
                .map(Map.Entry::getKey)
                .map(ClientId::asLong)
                .collect(Collectors.toSet());

        return preValidationTool.validateModelChangesList(modelChangesList, visibleClientIds);
    }
}
