package ru.yandex.direct.core.entity.clientphone;

import java.util.List;

import ru.yandex.direct.core.entity.clientphone.repository.ClientPhoneRepository;
import ru.yandex.direct.core.entity.trackingphone.model.ClientPhone;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.operation.add.ModelsPreValidatedStep;
import ru.yandex.direct.operation.add.SimpleAbstractAddOperation;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.clientphone.validation.ClientPhoneValidationService.validateTelephonyPhones;

/**
 * Операция добавляет клиентские номера client_phones, которые используются для коллтрекинга на сайте.
 * Это такие номера, у которых phoneType = TELEPHONY, permalinkId = null.
 */
public class CalltrackingOnSitePhoneAddOperation extends SimpleAbstractAddOperation<ClientPhone, Long> {
    private final ClientId clientId;

    private final ClientPhoneRepository clientPhoneRepository;
    private final TelephonyPhoneService telephonyPhoneService;

    CalltrackingOnSitePhoneAddOperation(
            ClientId clientId,
            List<ClientPhone> clientPhones,
            ClientPhoneRepository clientPhoneRepository,
            TelephonyPhoneService telephonyPhoneService
    ) {
        super(Applicability.PARTIAL, clientPhones);

        this.clientId = clientId;

        this.clientPhoneRepository = clientPhoneRepository;
        this.telephonyPhoneService = telephonyPhoneService;
    }

    @Override
    protected void onPreValidated(ModelsPreValidatedStep<ClientPhone> modelsPreValidatedStep) {
        modelsPreValidatedStep.getPreValidModelsMap().values().forEach(
                phone -> {
                    String redirectPhone = phone.getPhoneNumber().getPhone();
                    fillModel(phone, redirectPhone);
                }
        );
    }

    private void fillModel(ClientPhone phone, String redirectPhone) {
        var telephonyPhoneValues = telephonyPhoneService.attachTelephony(clientId, phone, redirectPhone);
        if (telephonyPhoneValues == null) {
            // не удалось привязать номер Телефонии. Валидация пометит этот номер как невалидный
            return;
        }
        phone.setTelephonyServiceId(telephonyPhoneValues.getTelephonyServiceId());
        phone.setTelephonyPhone(telephonyPhoneValues.getTelephonyPhone());
    }

    @SuppressWarnings("rawtypes")
    @Override
    protected void validate(ValidationResult<List<ClientPhone>, Defect> preValidationResult) {
        ValidationResult<List<ClientPhone>, Defect> validationResult = validateTelephonyPhones(getModels());
        preValidationResult.merge(validationResult);
    }

    @Override
    protected List<Long> execute(List<ClientPhone> validModelsToApply) {
        return clientPhoneRepository.add(clientId, validModelsToApply);
    }
}
