package ru.yandex.direct.core.entity.clientphone;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import ru.yandex.direct.core.entity.clientphone.repository.ClientPhoneRepository;
import ru.yandex.direct.core.entity.clientphone.validation.ClientPhoneValidationService;
import ru.yandex.direct.core.entity.trackingphone.model.ClientPhone;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.operation.add.ModelsValidatedStep;
import ru.yandex.direct.operation.add.SimpleAbstractAddOperation;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

/**
 * Операция для добавления телефонов типа
 * {@link ru.yandex.direct.core.entity.trackingphone.model.ClientPhoneType#MANUAL}
 */
public class ClientPhoneAddOperation extends SimpleAbstractAddOperation<ClientPhone, Long> {

    private final ClientPhoneRepository clientPhoneRepository;

    private final ClientId clientId;

    ClientPhoneAddOperation(
            ClientId clientId,
            List<ClientPhone> clientPhones,
            ClientPhoneRepository clientPhoneRepository) {
        super(Applicability.PARTIAL, clientPhones);
        this.clientId = clientId;
        this.clientPhoneRepository = clientPhoneRepository;
    }

    @Override
    protected void validate(ValidationResult<List<ClientPhone>, Defect> preValidationResult) {
        Map<Long, String> existingManualNumbers = clientPhoneRepository.getManualPhoneNumbers(clientId);
        ValidationResult<List<ClientPhone>, Defect> validationResult =
                ClientPhoneValidationService.validate(getModels(), existingManualNumbers);
        preValidationResult.merge(validationResult);
    }

    @Override
    protected void onModelsValidated(ModelsValidatedStep<ClientPhone> modelsValidatedStep) {
        Collection<ClientPhone> clientPhones = modelsValidatedStep.getValidModelsMap().values();
        clientPhones.forEach(s -> s.setClientId(clientId));
    }

    @Override
    protected List<Long> execute(List<ClientPhone> validModelsToApply) {
        return clientPhoneRepository.add(clientId, validModelsToApply);
    }
}
