package ru.yandex.direct.core.entity.clientphone;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

import javax.annotation.Nonnull;

import ru.yandex.direct.common.net.NetAcl;
import ru.yandex.direct.core.entity.banner.container.BannersOperationContainer;
import ru.yandex.direct.core.util.CoreHttpUtil;
import ru.yandex.direct.feature.FeatureName;

import static java.util.Collections.emptyMap;
import static java.util.Collections.emptySet;

public class ClientPhoneIdsByTypeContainer {

    private final Map<Long, Set<Long>> notManualPhoneIdsByPermalink;
    private final Set<Long> manualPhoneIds;
    private boolean allowOverrideNotManual;

    public static ClientPhoneIdsByTypeContainer empty() {
        return new ClientPhoneIdsByTypeContainer(emptyMap(), emptySet());
    }

    public ClientPhoneIdsByTypeContainer() {
        notManualPhoneIdsByPermalink = new HashMap<>();
        manualPhoneIds = new HashSet<>();
    }

    public ClientPhoneIdsByTypeContainer(Map<Long, Set<Long>> notManualPhoneIdsByPermalink, Set<Long> manualPhoneIds) {
        this.notManualPhoneIdsByPermalink = notManualPhoneIdsByPermalink;
        this.manualPhoneIds = manualPhoneIds;
    }

    public Map<Long, Set<Long>> getNotManualPhoneIdsByPermalink() {
        return notManualPhoneIdsByPermalink;
    }

    public Set<Long> getNotManualPhoneIds(Long permalinkId) {
        return notManualPhoneIdsByPermalink.getOrDefault(permalinkId, emptySet());
    }

    public Set<Long> getManualPhoneIds() {
        return manualPhoneIds;
    }

    /**
     * {@code true}, если заданный телефон нашелся среди ручных или среди телефонов, связанных с заданной организацией.
     */
    public boolean contains(@Nonnull Long permalinkId, Long phoneId) {
        return getManualPhoneIds().contains(phoneId) || getNotManualPhoneIds(permalinkId).contains(phoneId);
    }

    public void addNotManual(Long permalink, Long phoneId) {
        notManualPhoneIdsByPermalink.computeIfAbsent(permalink, v -> new HashSet<>()).add(phoneId);
    }

    public void addManual(Long phoneId) {
        manualPhoneIds.add(phoneId);
    }

    public void setAllowOverrideNotManualPhoneWithNoRights(BannersOperationContainer container, NetAcl netAcl) {
        boolean requestFromInternalNetwork = Optional.ofNullable(CoreHttpUtil.getRemoteAddressFromAuthOrDefault())
                .map(netAcl::isInternalIp)
                .orElse(false);
        boolean isUcFeatureEnabled =
                container.isFeatureEnabledForClient(FeatureName.UNIVERSAL_CAMPAIGNS_ENABLED_FOR_UAC) ||
                        (!container.isFeatureEnabledForClient(FeatureName.UNIVERSAL_CAMPAIGNS_BETA_DISABLED)
                                && requestFromInternalNetwork);
        boolean isTelephonyAllowed = container.isFeatureEnabledForClient(FeatureName.TELEPHONY_ALLOWED);
        this.allowOverrideNotManual = isUcFeatureEnabled || isTelephonyAllowed;
    }

    public boolean isAllowedOverrideNotManual() {
        return this.allowOverrideNotManual;
    }
}
