package ru.yandex.direct.core.entity.clientphone;

import java.time.Duration;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.common.lettuce.LettuceConnectionProvider;
import ru.yandex.direct.redislock.DistributedLock;
import ru.yandex.direct.redislock.lettuce.LettuceLockBuilder;

@Component
@ParametersAreNonnullByDefault
public class ClientPhoneLocker {

    private static final Duration LOCK_TIMEOUT = Duration.ofMillis(300);

    private final LettuceLockBuilder lockBuilder;

    public ClientPhoneLocker(LettuceConnectionProvider lettuce) {
        this.lockBuilder = LettuceLockBuilder.newBuilder(lettuce::getConnection)
                .withMaxLocks(1)
                .withLockAttemptTimeout(LOCK_TIMEOUT.toMillis())
                .withKeyPrefix("client-phone")
                .withTTL(Duration.ofMinutes(10).toMillis());
    }

    public DistributedLock create(String key) {
        return lockBuilder.createLock(key);
    }

}
