package ru.yandex.direct.core.entity.clientphone.repository;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.clientphone.ClientPhoneUtils;
import ru.yandex.direct.core.entity.trackingphone.model.PhoneNumber;
import ru.yandex.direct.core.entity.vcard.model.Phone;

public class ClientPhoneMapping {

    @Nullable
    public static String phoneNumberToDb(@Nullable PhoneNumber phoneNumber) {
        if (phoneNumber == null) {
            return null;
        }
        Phone phone = ClientPhoneUtils.toPhone(phoneNumber);
        String phoneStr = phone.getCountryCode() + "#" + phone.getCityCode() + "#" + phone.getPhoneNumber() + "#";
        if (phone.getExtension() != null) {
            phoneStr += phone.getExtension();
        }
        return phoneStr;
    }

    @Nullable
    public static PhoneNumber phoneNumberFromDb(@Nullable String phoneStr) {
        if (phoneStr == null) {
            return null;
        }
        phoneStr = phoneStr.replaceAll("-", "");
        String[] parts = phoneStr.split("#");
        PhoneNumber phoneNumber = new PhoneNumber()
                .withPhone(parts[0] + parts[1] + parts[2]);
        if (parts.length > 3) {
            phoneNumber.setExtension(Long.valueOf(parts[3]));
        }
        return phoneNumber;
    }
}
