package ru.yandex.direct.core.entity.contentpromotion;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@ParametersAreNonnullByDefault
public class ContentPromotionMetaWithStatus {
    private final DefaultContentPromotionMeta meta;
    private final ContentStatus contentStatus;
    private final ValidationResult<DefaultContentPromotionMeta, Defect> validationResult;

    public ContentPromotionMetaWithStatus(@Nullable DefaultContentPromotionMeta meta,
                                          ContentStatus contentStatus,
                                          ValidationResult<DefaultContentPromotionMeta, Defect> validationResult) {
        this.meta = meta;
        this.contentStatus = contentStatus;
        this.validationResult = validationResult;
    }

    @Nullable
    public DefaultContentPromotionMeta getMeta() {
        return meta;
    }

    public ContentStatus getContentStatus() {
        return contentStatus;
    }

    public ValidationResult<DefaultContentPromotionMeta, Defect> getValidationResult() {
        return validationResult;
    }
}
